﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using System.ServiceModel;
using System.ServiceModel.Web;
using Microsoft.AccessControl.SDK.ACSCalculator.AuthorizationManager;


namespace ProAzure.MachineInfo.Service
{
    public class WorkerRole : RoleEntryPoint
    {
        const string serviceNamespace = "proazure-1";
        const string trustedTokenPolicyKey = "8O++r46Eo6e6VhGQaHSCfINhYMMCu14xsAectW2EFfk=";

        const string acsHostName = "accesscontrol.windows.net";
        const string trustedAudience = "http://localhost/acsexample";
        const string requiredClaimType = "action";

public override void Run()
{
    // This is a sample worker implementation. Replace with your logic.
    Trace.WriteLine("ACSMachineInfoWorker entry point called", "Information");

    var externalEndpoint = RoleEnvironment.CurrentRoleInstance.InstanceEndpoints["Endpoint1"];
    WebHttpBinding binding = new WebHttpBinding(WebHttpSecurityMode.None);

    Uri address = new Uri(trustedAudience);

    WebServiceHost host = new WebServiceHost(typeof(ACSExample));
    host.AddServiceEndpoint(typeof(IACSExample), binding, address);

    host.Authorization.ServiceAuthorizationManager = new ACSAuthorizationManager(
        acsHostName,
        serviceNamespace,
        trustedAudience,
        Convert.FromBase64String(trustedTokenPolicyKey),
        requiredClaimType);

    
    try
    {
        host.Open();
        while (true)
        {
            Thread.Sleep(10000);
            Trace.WriteLine("Working", "Information");
        }
    }
    finally
    {
        host.Close();

    }
}

        public override bool OnStart()
        {
            // Set the maximum number of concurrent connections 
            ServicePointManager.DefaultConnectionLimit = 12;

            DiagnosticMonitor.Start("DiagnosticsConnectionString");

            // For information on handling configuration changes
            // see the MSDN topic at http://go.microsoft.com/fwlink/?LinkId=166357.
            RoleEnvironment.Changing += RoleEnvironmentChanging;

            return base.OnStart();
        }

        private void RoleEnvironmentChanging(object sender, RoleEnvironmentChangingEventArgs e)
        {
            // If a configuration setting is changing
            if (e.Changes.Any(change => change is RoleEnvironmentConfigurationSettingChange))
            {
                // Set e.Cancel to true to restart this role instance
                e.Cancel = true;
            }
        }
    }
}
